<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Mdata;

class Utama extends Controller
{
    public function statusAPI()
    {
        $dtresponse = [
            "kode" => "01",
            "status" => "API Berjalan dengan baik"
        ];
        return response()->json($dtresponse, 200);
    }

    public function backupData(Request $xyz)
    {
        $nama = $xyz->input("nama_backup");
        $dtx = base64_decode($xyz->input("dtx"));
        $id = floor(microtime(true) * 1000);
        $arr_data = explode("#", $dtx);
        $mx = new Mdata();
        $proses = $mx->TambahBackup($id, $nama);
        
        if ($proses == "1") {
            $berhasil = 0;
            $gagal = 0;

            foreach ($arr_data as $k) {
                $arr_data2 = explode("|", $k);
                $idx = $arr_data2[0];
                $deskripsix = $arr_data2[1];
                $waktux = $arr_data2[2];
                $nominalx = $arr_data2[3];
                $jeniszx = $arr_data2[4];

                $proses2 = $mx->TambahTransaksi($id . "-" . $idx, $id, $waktux, $nominalx, $jeniszx, $deskripsix);
                $proses2 == "1" ? $berhasil++ : $gagal++;
            }

            return response()->json([
                "kode" => "1",
                "pesan" => "Proses Backup Berhasil dengan Rincian ",
                "berhasil" => $berhasil,
                "gagal" => $gagal
            ]);
        } else {
            return response()->json([
                "kode" => "0",
                "pesan" => "Proses Backup Gagal, Periksa Kembali Isian Anda"
            ]);
        }
    }
}
